/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.base;

import filenet.vw.api.VWException;
import filenet.vw.base.VWAuthItem;
import filenet.vw.base.VWCapsuleAES;

public abstract class VWConvertTwo {
    private char[] s = new char[]{'+', '-'};
    private char[] v = new char[]{'1', 'a'};
    private static final char[] S_BASE64CHAR;
    private static final char S_BASE64PAD = '=';
    private static final byte[] S_DECODETABLE;

    protected String getEString(String value1, String value2) throws Exception {
        try {
            VWCapsuleAES en = new VWCapsuleAES();
            String aStr = en.encrypt(value1, value2);
            return aStr;
        }
        catch (Throwable t) {
            throw new VWException(t);
        }
    }

    protected VWAuthItem getDString(String token) throws Exception {
        try {
            if (token.startsWith(VWCapsuleAES.versionDelimeter)) {
                VWCapsuleAES en = new VWCapsuleAES();
                VWAuthItem item = en.decrypt(token);
                return item;
            }
            long nCheckSum = 0L;
            int lastSepIndex = -1;
            int firstSepIndex = 0;
            int nPassSize = 0;
            if (token == null || token.length() <= 0) {
                return null;
            }
            if (this.getKey(0) != null && this.getKey(0).equals("MIIBCTCBtAIBADBPMQswCQYDeQQGEwJV6s4fUzEQMA4GA1UECBMHRmxvcmlkYTEYMBYGA1UEChMPRXllcyBvbiBUaGUgV2ViMRQwEgYDVQQDFAt3d3cuZXR3Lm5ldDBcMA0GCSqGSIb3DQEBAQUAA0sAMEgCQQCeojtjnHqg0GTxp+XZ56RaSe1iZWpumXjU6Sx7v1FdXzsY1oLOQa090Jtnu1WsQRHh0yDS+45oncjKm1zCIZAgMBAAGgADANBgkqhkiG9w0BAQQFAANBAFBj9g+NiUh8YWPrFGntgf4miUdwqUshptjJy4PjdsD*3ugy5avvuh3GPpGh2aYXIjHpJXTUBQyzxSEIINYtc")) {
                int i;
                byte[] decodeBytes = VWConvertTwo.decode(token);
                if (decodeBytes == null) {
                    return null;
                }
                int len = decodeBytes.length;
                byte ver = decodeBytes[0];
                if (ver != this.v[0] && ver != this.v[1]) {
                    return null;
                }
                for (i = len - 1; i >= 0; --i) {
                    if (decodeBytes[i] != this.s[0] && decodeBytes[i] != this.s[1]) continue;
                    lastSepIndex = i;
                    break;
                }
                if (lastSepIndex == -1) {
                    return null;
                }
                for (i = len - 1; i > lastSepIndex && decodeBytes[i] == 0; --i) {
                }
                int nCheckSumChars = i - lastSepIndex;
                byte[] bCheckSum = new byte[nCheckSumChars];
                System.arraycopy(decodeBytes, lastSepIndex + 1, bCheckSum, 0, nCheckSumChars);
                String sCheckSum = new String(bCheckSum);
                try {
                    nCheckSum = Long.parseLong(sCheckSum);
                }
                catch (NumberFormatException e) {
                    return null;
                }
                if (nCheckSum != this.checkSumFromBytes(decodeBytes, 0, lastSepIndex)) {
                    return null;
                }
                for (i = 0; i < len; ++i) {
                    if (decodeBytes[i] != this.s[0] && decodeBytes[i] != this.s[1]) continue;
                    firstSepIndex = i;
                    break;
                }
                if (firstSepIndex == -1) {
                    return null;
                }
                byte[] bPWLen = new byte[firstSepIndex - 1];
                System.arraycopy(decodeBytes, 1, bPWLen, 0, firstSepIndex - 1);
                String sPWLen = new String(bPWLen);
                try {
                    nPassSize = Integer.parseInt(sPWLen);
                }
                catch (NumberFormatException e) {
                    return null;
                }
                int nNamePassSize = lastSepIndex - firstSepIndex - 1;
                if (nNamePassSize < nPassSize) {
                    return null;
                }
                byte[] namePassBytes = new byte[nNamePassSize];
                System.arraycopy(decodeBytes, firstSepIndex + 1, namePassBytes, 0, nNamePassSize);
                int nNameSize = nNamePassSize - nPassSize;
                byte[] nameArr = new byte[nNameSize];
                byte[] passArr = new byte[nPassSize];
                int tmpIndex = 0;
                for (i = 0; i < nPassSize; ++i) {
                    passArr[i] = namePassBytes[tmpIndex++];
                    if (i >= nNameSize) continue;
                    nameArr[i] = namePassBytes[tmpIndex++];
                }
                while (i < nNameSize) {
                    nameArr[i++] = namePassBytes[tmpIndex++];
                }
                String password = new String(passArr, "UTF-8");
                byte[] tmpArr = new byte[nNameSize];
                tmpIndex = nNameSize - 1;
                for (i = 0; i < nNameSize; ++i) {
                    tmpArr[i] = nameArr[tmpIndex--];
                }
                String name = new String(tmpArr, "UTF-8");
                return new VWAuthItem(name, password);
            }
            return new VWAuthItem(this.getEString("asdflkj238welkj", token), this.getEString("laksdjflaskf", token));
        }
        catch (Throwable t) {
            throw new VWException(t);
        }
    }

    protected String getKey(int id) {
        return null;
    }

    private long checksum(String s) {
        long a = 0L;
        long b = 0L;
        if (s != null) {
            for (int i = 0; i < s.length(); ++i) {
                a = (a + (long)s.charAt(i)) % 255L;
                b = (a + b) % 255L;
            }
        }
        return a * 256L + b;
    }

    private long checkSumFromBytes(byte[] s, int begin, int end) {
        long a = 0L;
        long b = 0L;
        long c = 0L;
        if (s != null) {
            for (int i = begin; i <= end; ++i) {
                c = (long)s[i] & 0xFFL;
                a = (a + c) % 255L;
                b = (a + b) % 255L;
            }
        }
        c = a * 256L + b;
        return c;
    }

    private static int decode0(char[] ibuf, byte[] obuf, int wp) {
        int outlen = 3;
        if (ibuf[3] == '=') {
            outlen = 2;
        }
        if (ibuf[2] == '=') {
            outlen = 1;
        }
        byte b0 = S_DECODETABLE[ibuf[0]];
        byte b1 = S_DECODETABLE[ibuf[1]];
        byte b2 = S_DECODETABLE[ibuf[2]];
        byte b3 = S_DECODETABLE[ibuf[3]];
        switch (outlen) {
            case 1: {
                obuf[wp] = (byte)(b0 << 2 & 0xFC | b1 >> 4 & 3);
                return 1;
            }
            case 2: {
                obuf[wp++] = (byte)(b0 << 2 & 0xFC | b1 >> 4 & 3);
                obuf[wp] = (byte)(b1 << 4 & 0xF0 | b2 >> 2 & 0xF);
                return 2;
            }
            case 3: {
                obuf[wp++] = (byte)(b0 << 2 & 0xFC | b1 >> 4 & 3);
                obuf[wp++] = (byte)(b1 << 4 & 0xF0 | b2 >> 2 & 0xF);
                obuf[wp] = (byte)(b2 << 6 & 0xC0 | b3 & 0x3F);
                return 3;
            }
        }
        throw new RuntimeException("Invalid");
    }

    public static byte[] decode(String data) {
        char[] ibuf = new char[4];
        int ibufcount = 0;
        byte[] obuf = new byte[data.length() / 4 * 3 + 3];
        int obufcount = 0;
        for (int i = 0; i < data.length(); ++i) {
            char ch = data.charAt(i);
            if (ch != '=' && (ch >= S_DECODETABLE.length || S_DECODETABLE[ch] == 127)) continue;
            ibuf[ibufcount++] = ch;
            if (ibufcount != ibuf.length) continue;
            ibufcount = 0;
            obufcount += VWConvertTwo.decode0(ibuf, obuf, obufcount);
        }
        if (obufcount == obuf.length) {
            return obuf;
        }
        byte[] ret = new byte[obufcount];
        System.arraycopy(obuf, 0, ret, 0, obufcount);
        return ret;
    }

    public static String encodeEx(byte[] data) {
        return VWConvertTwo.encode(data, 0, data.length);
    }

    public static String encode(byte[] data, int off, int len) {
        int i;
        int rest;
        if (len <= 0) {
            return "";
        }
        char[] out = new char[len / 3 * 4 + 4];
        int rindex = off;
        int windex = 0;
        for (rest = len - off; rest >= 3; rest -= 3) {
            i = ((data[rindex] & 0xFF) << 16) + ((data[rindex + 1] & 0xFF) << 8) + (data[rindex + 2] & 0xFF);
            out[windex++] = S_BASE64CHAR[i >> 18];
            out[windex++] = S_BASE64CHAR[i >> 12 & 0x3F];
            out[windex++] = S_BASE64CHAR[i >> 6 & 0x3F];
            out[windex++] = S_BASE64CHAR[i & 0x3F];
            rindex += 3;
        }
        if (rest == 1) {
            i = data[rindex] & 0xFF;
            out[windex++] = S_BASE64CHAR[i >> 2];
            out[windex++] = S_BASE64CHAR[i << 4 & 0x3F];
            out[windex++] = 61;
            out[windex++] = 61;
        } else if (rest == 2) {
            i = ((data[rindex] & 0xFF) << 8) + (data[rindex + 1] & 0xFF);
            out[windex++] = S_BASE64CHAR[i >> 10];
            out[windex++] = S_BASE64CHAR[i >> 4 & 0x3F];
            out[windex++] = S_BASE64CHAR[i << 2 & 0x3F];
            out[windex++] = 61;
        }
        return new String(out, 0, windex);
    }

    static {
        int i;
        S_BASE64CHAR = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
        S_DECODETABLE = new byte[128];
        for (i = 0; i < S_DECODETABLE.length; ++i) {
            VWConvertTwo.S_DECODETABLE[i] = 127;
        }
        for (i = 0; i < S_BASE64CHAR.length; ++i) {
            VWConvertTwo.S_DECODETABLE[VWConvertTwo.S_BASE64CHAR[i]] = (byte)i;
        }
    }
}

